package examples;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/**
 * Example of a common programmer bug when using an iterator.
 * 
 */
public class Dice {

	enum Face {
		ONE, TWO, THREE, FOUR, FIVE, SIX
	};

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		System.out.println("Goal: Show all combinations from rolling two dice");

		// This loop doesn't produce the expected results
		Collection<Face> faces = Arrays.asList(Face.values());
		System.out.println("Unexpected results: ");
		for (Iterator<Face> i = faces.iterator(); i.hasNext();) {
			for (Iterator<Face> j = faces.iterator(); j.hasNext();) {
				System.out.println(i.next() + " " + j.next());
			}
		}

		System.out.println("Expected results: ");

		// This loop does.
		for (Face one : Face.values()) {
			for (Face two : Face.values()) {
				System.out.println(one + " " + two);
			}
		}
	}

}
