/**
 * This class converts from inches to centimeters.
 * 
 * This class demonstrates variable declarations and class constants, 
 * as well as command-line arguments.
 *
 * @author Sara Sprenkle
 *
 */
public class Conversion2 {  
    
    static final double CM_PER_INCH = 2.540;
  
   /**
    * Called when user runs 
    *  java Conversion2
    */
    public static void main(String[] args) {
        
        if( args.length < 1 ) {
            System.out.println("Usage: java Conversion2 <numinches>");
            System.exit(1);
        }
        
        String numInchesStr = args[0];
        double numInches = Double.parseDouble(numInchesStr);
        double numCM = numInches*CM_PER_INCH;
        
        // need to put + in between string literals and variables
        // need to put explicit spaces into string literals
        // Note that Java will automatically convert the ints and doubles
        // to strings
        System.out.println("There are " + numCM + " cm in " + numInches + " inches.");       
        
    }
}
