package examples;

import javax.swing.*;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * When a button is pressed, it colors the background of the panel the
 * appropriate color.
 * 
 * The JFrame listens to its button's actions
 * 
 * @author sarasprenkle
 * 
 */
public class ColoredBackgroundSelfListener extends JFrame implements ActionListener{

	public ColoredBackgroundSelfListener() {
		setTitle("Colored Background - Self-Listener");
		setBackground(Color.white);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Container cp = getContentPane();
		cp.setLayout(new FlowLayout());

		// create buttons and add to content pane
		red = new JButton("Red");
		red.setForeground(Color.red);
		red.addActionListener(this);

		green = new JButton("Green");
		green.setForeground(Color.GREEN);
		green.addActionListener(this);

		blue = new JButton("Blue");
		blue.setForeground(Color.blue);
		blue.addActionListener(this);
		
		cp.add(red);
		cp.add(green);
		cp.add(blue);

		pack();
		setVisible(true);
	}
	

	@Override
	public void actionPerformed(ActionEvent event) {
		// needs to determine source
		Object source = event.getSource();
		if( source == blue) {
			setBackground(Color.blue);
		} else if( source == red ) {
			setBackground(Color.red);
		} else if( source == green ) {
			setBackground(Color.green);
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ColoredBackground cb = new ColoredBackground();
	}

	private JButton blue;
	private JButton green;
	private JButton red;
}
