package cards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Represents a deck of playing cards
 * 
 * @author Sara Sprenkle and CS209
 * 
 */
public class Deck {

	// define our variable as an interface variable, List.
	// Note that only Card objects can be put into the list or taken out of the
	// list.
	/** a list of Card objects */
	private List<Card> deck = new ArrayList<Card>(); // Assign the ArrayList
														// implementation
														// to the List variable

	/**
	 * Creates a new, shuffled deck of cards
	 */
	public Deck() {
		restart(true);
	}

	/**
	 * Creates a new deck of cards
	 * 
	 * @param shuffle
	 *            - true if the cards should be shuffled
	 */
	public Deck(boolean shuffle) {
		restart(shuffle);
	}

	/**
	 * Restart the deck from the beginning.
	 * 
	 * @param shuffle
	 *            - true if the cards should be shuffled
	 */
	public void restart(boolean shuffle) {
		// removes all the Cards from the deck
		deck.clear();

		// Use the enums defined in the Card class
		for (Card.Suit suit : Card.Suit.values()) {
			for (Card.Rank rank : Card.Rank.values()) {
				Card c = new Card(rank, suit);
				deck.add(c);
			}
		}

		if (shuffle) {
			shuffle();
		}
	}

	/**
	 * Display the contents of the deck.
	 */
	public void display() {
		for (Card c : deck) {
			System.out.println(c);
		}
	}

	/**
	 * Shuffles the deck of cards
	 */
	public void shuffle() {
		Collections.shuffle(deck);
	}

	/**
	 * Draws the first card from the deck, removes it from the deck, and returns
	 * the chosen card
	 * 
	 * @return the top card from the deck, which is removed
	 */
	public Card draw() {
		return deck.remove(0);
	}

	/**
	 * Returns a list of cards that are drawn (thus from the deck.
	 * 
	 * @param numCards
	 * @return a list of cards (of the specified size)
	 */
	public List<Card> deal(int numCards) {
		List<Card> hand = new ArrayList<Card>();
		for (int i = 0; i < numCards; i++) {
			hand.add(draw());
		}
		return hand;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Deck d = new Deck();
		d.display();
	}

}
