package cards;

import java.util.*;

/**
 * 
 */
class Deal {

	/**
	 * A little different dealing than before... Does not specify the type of
	 * objects in the List. Doesn't need to--still works.
	 * 
	 * @param deck
	 * @param n
	 * @return
	 */
	public static List dealHand(List deck, int n) {
		int deckSize = deck.size();
		List handView = deck.subList(deckSize - n, deckSize);
		List hand = new ArrayList(handView);
		handView.clear();
		return hand;
	}

	public static void main(String[] args) {
		int numHands = Integer.parseInt(args[0]);
		int cardsPerHand = Integer.parseInt(args[1]);

		// Make a normal 52-card deck.
		String[] suit = new String[] { "Spades", "Hearts", "Diamonds", "Clubs" };
		String[] rank = new String[] { "Ace", "2", "3", "4", "5", "6", "7",
				"8", "9", "10", "Jack", "Queen", "King" };
		List<String> deck = new ArrayList<String>();

		// initialize the deck
		for (int i = 0; i < suit.length; i++)
			for (int j = 0; j < rank.length; j++)
				deck.add(rank[j] + " of " + suit[i]);
		
		

		Collections.shuffle(deck);

		for (int i = 0; i < numHands; i++)
			System.out.println(dealHand(deck, cardsPerHand));

		System.out.println("\n Changing decks ... \n");
		
		List<Card> cardDeck = new ArrayList<Card>();
		for (Card.Suit s : Card.Suit.values()) {
			for (Card.Rank r : Card.Rank.values()) {
				cardDeck.add( new Card(r, s) );
			}
		}
		
		Collections.shuffle(cardDeck);
		
		for (int i = 0; i < numHands; i++)
			System.out.println(dealHand(cardDeck, cardsPerHand));
	}
}