/**
 * This class demonstrates using dynamic dispatch
 *
 * @author Sara Sprenkle
 *
 */
public class DynamicDispatchExample {  
    
   /**
    * Called when user runs 
    *  java DynamicDispatchExample
    */
    public static void main(String[] args) {
        Parent p = new Parent();
        Child c = new Child();
        
        p.method1();
        System.out.println("");

        c.method1();
        System.out.println("");
        
        p.method2();
        System.out.println("");

        c.method2();
        System.out.println("");
    }
}

class Parent {
 
    public Parent() {
    }
    
    public void method1() {
        System.out.println("Parent: method1");   
    }
    
    public void method2() {
        System.out.println("Parent: method2");
        method1();
    }
    
}

class Child extends Parent {
 
    public Child() {
    }
    
    public void method1() {
        System.out.println("Child: method1");   
    }
    
}

