/**
* Class represents a rooster.
* 
* @author Sara Sprenkle
*/
public class Rooster extends Chicken {
    
    /**
     *
     */
    public Rooster( String name, int height, double weight ) {
        // call to the super constructor must be the first line in constructor
	super( name, height, weight, false);
        // NOTE: reduces amount of code required in Rooster class,
        // increases code reuse, decreases code duplication
    }
    
    // new functionality
    public void crow() {
        System.out.println("Cocka-Doodle-Doo!");
    }
    
    // overrides superclass; greater gains
    @Override
    public void feed() {
	weight += .5;
	height += 2;
    }
    
    public static void main(String argv[]) {
        Rooster leghorn = new Rooster("Foghorn", 22, 10 );
        System.out.println(leghorn);
        leghorn.crow();
        leghorn.feed();
        System.out.println(leghorn);
    }

}
