package examples;

/**
 * What is the output from the main method of OverloadPlay ?
 * 
 * @author sprenkle
 * 
 */

class Parent {
	public void method() {
		System.out.println("Parent");
	}
}

class Child extends Parent {
	@Override
	public void method() {
		System.out.println("Child");
	}
}

public class OverloadPlay {

	public static void print(Parent parent) {
		System.out.println("Static Parent");
	}

	public static void print(Child child) {
		System.out.println("Static Child");
	}

	public void instancePrint(Parent parent) {
		System.out.println("Parent");
	}

	public void instancePrint(Child child) {
		System.out.println("Child");
	}

	public static void main(String[] args) {
		Child child = new Child();
		Parent p = child;

		print(p);
		new OverloadPlay().instancePrint(p);
	}
}