/**
 * Class represents a rooster.
 * 
 * How to extend a class whose instance variables are private.
 * 
 * @author Sara Sprenkle
 */
public class Rooster2 extends Chicken2 {
    
    /**
     *
     */
    public Rooster2(String name, int height, double weight) {
	// call to the super constructor must be the first line in constructor
	super(name, height, weight, false);
	// NOTE: reduces amount of code required in Rooster class,
	// increases code reuse, decreases code duplication
    }
    
    // new functionality
    public void crow() {
	System.out.println("Cocka-Doodle-Doo!");
    }
    
    /**
     * overrides superclass; greater gains
     */
    @Override
    public void feed() {
	// can't access private instance variables directly but have
	// the getters and setters
	this.setWeight(this.getWeight() + .5);
	this.setHeight(this.getHeight() + 2);
    }

    public static void main(String argv[]) {
	Rooster2 leghorn = new Rooster2("Foghorn", 22, 10);
	System.out.println(leghorn);
	leghorn.crow();
	leghorn.feed();
	System.out.println(leghorn);
    }

}