/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.swing;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sf.jtreemap.swing.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMapNode
extends DefaultMutableTreeNode {
    private static final int DEFAULT_BORDER_SIZE = 3;
    private static final long serialVersionUID = 742372833853976103L;
    private static int border = 3;
    private int height;
    private Value value;
    private double weight = 0.0;
    private int width;
    private int x;
    private int y;

    public static int getBorder() {
        return border;
    }

    public static void setBorder(int border) {
        TreeMapNode.border = border;
    }

    public TreeMapNode(String label) {
        super(label);
        this.allowsChildren = true;
    }

    public TreeMapNode(String label, double weight, Value value) {
        super(label);
        this.weight = Math.abs(weight);
        this.value = value;
        this.allowsChildren = false;
    }

    public void add(TreeMapNode newChild) {
        super.add(newChild);
        this.setWeight(this.weight + newChild.getWeight());
    }

    public TreeMapNode getActiveLeaf(int xParam, int yParam) {
        if (this.isLeaf()) {
            if (xParam >= this.getX() && xParam <= this.getX() + this.getWidth() && yParam >= this.getY() && yParam <= this.getY() + this.getHeight()) {
                return this;
            }
        } else {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                TreeMapNode node = (TreeMapNode)e.nextElement();
                if (xParam < node.getX() || xParam > node.getX() + node.getWidth() || yParam < node.getY() || yParam > node.getY() + node.getHeight()) continue;
                return node.getActiveLeaf(xParam, yParam);
            }
        }
        return null;
    }

    public TreeMapNode getChild(int xParam, int yParam) {
        if (!this.isLeaf()) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                TreeMapNode node = (TreeMapNode)e.nextElement();
                if (xParam < node.getX() || xParam > node.getX() + node.getWidth() || yParam < node.getY() || yParam > node.getY() + node.getHeight()) continue;
                return node;
            }
        }
        return null;
    }

    public Vector<TreeMapNode> getChildren() {
        return this.children;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLabel() {
        return this.getUserObject().toString();
    }

    public String getLabelValue() {
        return this.value.getLabel();
    }

    public Value getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value.getValue();
    }

    public double getWeight() {
        return this.weight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setDimension(int xParam, int yParam, int widthParam, int heightParam) {
        this.x = xParam;
        this.y = yParam;
        this.width = widthParam;
        this.height = heightParam;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setLabel(String label) {
        this.userObject = label;
    }

    public void setPosition(int xParam, int yParam) {
        this.x = xParam;
        this.y = yParam;
    }

    public void setSize(int widthParam, int heightParam) {
        this.width = widthParam;
        this.height = heightParam;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setWeight(double weight) {
        double newWeight = Math.abs(weight);
        if (this.parent != null) {
            ((TreeMapNode)this.parent).setWeight(((TreeMapNode)this.parent).weight - this.weight + newWeight);
        }
        this.weight = newWeight;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }
}

