/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.swing.provider;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.TreeMapNode;

public class ZoomPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 8468224816342601183L;
    public static final Icon UNZOOM_ICON = new ImageIcon(ZoomPopupMenu.class.getResource("icons/unzoom.png"));
    public static final Icon ZOOM_ICON = new ImageIcon(ZoomPopupMenu.class.getResource("icons/zoom.png"));
    private JTreeMap jTreeMap;
    private transient MouseListener mouseListener;
    private boolean showAbout;

    public ZoomPopupMenu(JTreeMap jTreeMap) {
        this(jTreeMap, false);
    }

    public ZoomPopupMenu(JTreeMap jTreeMap, boolean showAbout) {
        this.jTreeMap = jTreeMap;
        this.mouseListener = new HandleClickMouse();
        this.jTreeMap.addMouseListener(this.mouseListener);
        this.showAbout = showAbout;
    }

    private class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -8559400862920393294L;

        public AboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(null, "<html>JTreeMap powered by <a href=\"http://www.ObjectLab.co.uk\">ObjectLab.co.uk</a></html>");
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class ZoomAction
    extends AbstractAction {
        private static final long serialVersionUID = -8559400865920393294L;
        private TreeMapNode node;

        public ZoomAction(TreeMapNode node, Icon icon) {
            super(node.getLabel(), icon);
            this.node = node;
        }

        public void actionPerformed(ActionEvent e) {
            if (ZoomPopupMenu.this.jTreeMap.getTreeView() == null) {
                ZoomPopupMenu.this.jTreeMap.zoom(this.node);
                ZoomPopupMenu.this.jTreeMap.repaint();
            } else {
                TreePath path = new TreePath(this.node.getPath());
                ZoomPopupMenu.this.jTreeMap.getTreeView().setSelectionPath(path);
                ZoomPopupMenu.this.jTreeMap.getTreeView().scrollPathToVisible(path);
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class HandleClickMouse
    extends MouseAdapter {
        protected HandleClickMouse() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3 || e.getButton() == 1 && (e.isAltDown() || e.isControlDown() || e.isMetaDown() || e.isAltGraphDown())) {
                ZoomAction action;
                TreeMapNode orig;
                for (int i = ZoomPopupMenu.this.getComponentCount(); i > 0; --i) {
                    ZoomPopupMenu.this.remove(i - 1);
                }
                TreeMapNode cursor = orig = ZoomPopupMenu.this.jTreeMap.getDisplayedRoot();
                while (cursor.getParent() != null) {
                    TreeMapNode parent = (TreeMapNode)cursor.getParent();
                    action = new ZoomAction(parent, UNZOOM_ICON);
                    ZoomPopupMenu.this.insert(action, 0);
                    cursor = parent;
                }
                ZoomPopupMenu.this.addSeparator();
                cursor = orig;
                while (cursor.getChild(e.getX(), e.getY()) != null) {
                    TreeMapNode child = cursor.getChild(e.getX(), e.getY());
                    if (!child.isLeaf()) {
                        action = new ZoomAction(child, ZOOM_ICON);
                        ZoomPopupMenu.this.add(action);
                    }
                    cursor = child;
                }
                if (ZoomPopupMenu.this.showAbout) {
                    ZoomPopupMenu.this.addSeparator();
                    AboutAction action2 = new AboutAction();
                    ZoomPopupMenu.this.add(action2);
                }
                ZoomPopupMenu.this.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

