/**
 * A simple Java class that models a Chicken. The state of the chicken is its
 * name, height and weight.
 * 
 * @author Sara Sprenkle
 */
public class Chicken {

	// ------------ INSTANCE VARIABLES -------------------

	String name;
	
    /** the height of the chicken in centimeters */
	int height;
    
    /** the weight of the chicken in pounds */
	double weight;

	public Chicken(String name, int height, double weight) {
		this.name = name;
		this.height = height;
		this.weight = weight;
	}

	//
	// ----------- GETTER METHODS ------------
	// (also Accessor methods)

	/**
	 * @return the height of the chicken, in centimeters
	 */
	public int getHeight() {
		return height;
	}

	public double getWeight() {
		return weight;
	}

	public String getName() {
		return name;
	}

	//
	// ------------- MUTATORS -----------
	//

	public void feed() {
		weight += .3;
		height += 1;
	}
	
	//
	// ------------- SETTERS ----------
	//

	/**
	 * @param n
	 *            the name of the chicken
	 */
	public void setName(String n) {
		name = n;
	}

	/**
	 * @param h
	 *            the height of the chicken, in cm
	 */
	public void setHeight(int h) {
		height = h;
	}
    
    /**
	 * @param w
	 *            the weight of the chicken, in pounds
	 */
	public void setWeight(double w) {
		weight = w;
	}

	/**
	 * @param args
	 *            the command-line arguments
	 */
	public static void main(String args[]) {

		Chicken firstChicken = new Chicken("Fred", 38, 5.0);
        
        // feed Fred
        firstChicken.feed();
        
        // print out Fred's name, height, and weight
        System.out.println("Name: " + firstChicken.getName() );
        System.out.println("Height: " + firstChicken.getHeight() );
        System.out.println("Weight: " + firstChicken.getWeight() );

	}

}