package media.tests;

import static org.junit.Assert.*;

import java.util.GregorianCalendar;

import media.DVD;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DVDTest {
	
	DVD mydvd;
	
	@Before
	public void setUp() throws Exception {
		mydvd = new DVD("That Thing You Do!", 6480, new GregorianCalendar(
				1996, 9, 4), "PG", 3600);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testGetLength() {
		assertEquals(10080, mydvd.getLength());
	}

	@Test
	public void testToString() {
		assertEquals("*** DVD\nCurrently in the library: true\nTitle: That Thing You Do!\nLength:  2:48:00\nCopyright Year: 1996\nRating: PG", mydvd.toString());
	}

	@Test
	public void testGetBonusLength() {
		assertEquals(3600, mydvd.getBonusLength());
	}

	@Test
	public void testGetRating() {
		assertEquals("PG", mydvd.getRating());
	}

}
