import java.util.Arrays;

/**
 * This class shows how you can get memory leaks, even in Java
 *
 * @author Sara Sprenkle
 */
public class MemoryLeak { 
  
    private Object[] elements;
    private int size = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
   
    public MemoryLeak() {
        elements = new Object[DEFAULT_INITIAL_CAPACITY];   
    }
   
    public void push(Object e) {
        ensureCapacity();
        elements[size++] = e;
    }
   
    public Object pop() {
        if (size == 0) {
            System.err.println("Big oops!  Ran out of space"); // better to throw an exception ...
            System.exit(1);
        }
        Object popped = elements[size];
        size--;
        return popped;
    }
    
    private void ensureCapacity() {
        if (elements.length == size)
            elements = Arrays.copyOf(elements, 2 * size + 1);
    }
}
